package gov.va.vinci.dart.biz;

import java.util.List;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestNarrative extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		List<DartRequest> reqList = DartRequest.listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest req = reqList.get(0);
		Assert.assertNotNull(req);
		Assert.assertTrue(req.getId() > 0);
		
		Narrative narrative = Narrative.create("Narrative Description", req, "DNS", "Narrative Text");
		Assert.assertNotNull(narrative);
		Assert.assertTrue(narrative.getId() > 0);
		
		Narrative n2 = Narrative.findById(narrative.getId());
		Assert.assertNotNull(n2);
		Assert.assertEquals(n2, narrative);
	}
}
